<script src="https://in.paychangu.com/js/popup.js"></script>

<div class="bank-transfer card w-max-700 m-auto h-min-300">
  <div class="card-body">
    <div class="fs-5 mb-3">{{ __('BankTransfer::common.order_success') }}</div>

    <table class="table mb-3 table-bordered">
      <thead>
        <tr>
          <th>{{ __('BankTransfer::common.number') }}</th>
          <th>{{ __('BankTransfer::common.order_time') }}</th>
          <th>{{ __('BankTransfer::common.total') }}</th>
          <th>{{ __('BankTransfer::common.payment_method') }}</th>
        </tr>
      </thead>
      <tbody>
        <tr>
          <td>{{ $order->number }}</td>
          <td>{{ $order->created_at->format('Y-m-d') }}</td>
          <td>{{ currency_format($order->total) }}</td>
          <td>{{ __('BankTransfer::common.bank_transfer') }}</td>
        </tr>
      </tbody>
    </table>

    <div class="fs-5 mb-3">{{ __('Payment Methods') }}</div>

    <div class="full">

<div class="d-flex justify-content-between flex-wrap gap-3">
 
  <div class="logo_footer text-center">
    <a href="#" onclick="showModal(); return false;">
      <img width="70" src="{{ asset('images/standard.png') }}" alt="Bank A"
        style="transition: transform 0.3s ease-in-out; border-radius: 50%;"
        onmouseover="this.style.transform = 'scale(1.1)';"
        onmouseout="this.style.transform = 'scale(1)';" />
      <div class="mt-1">STD</div>
    </a>
  </div>


  <div class="logo_footer text-center">
    <a href="#" onclick="showModal(); return false;">
      <img width="70" src="{{ asset('images/fcb.png') }}" alt="Bank B"
        style="transition: transform 0.3s ease-in-out; border-radius: 50%;"
        onmouseover="this.style.transform = 'scale(1.1)';"
        onmouseout="this.style.transform = 'scale(1)';" />
      <div class="mt-1">FCB</div>
    </a>
  </div>

  
  <div class="logo_footer text-center">
    <a href="#" onclick="showModal(); return false;">
      <img width="70" src="{{ asset('images/fdh.png') }}" alt="Bank C"
        style="transition: transform 0.3s ease-in-out; border-radius: 50%;"
        onmouseover="this.style.transform = 'scale(1.1)';"
        onmouseout="this.style.transform = 'scale(1)';" />
      <div class="mt-1">FDH</div>
    </a>
  </div>

  
  <div class="logo_footer text-center">
    <a href="#" onclick="showModal(); return false;">
      <img width="70" src="{{ asset('images/natbank.png') }}" alt="Bank D"
        style="transition: transform 0.3s ease-in-out; border-radius: 50%;"
        onmouseover="this.style.transform = 'scale(1.1)';"
        onmouseout="this.style.transform = 'scale(1)';" />
      <div class="mt-1">NB</div>
    </a>
  </div>


  <div class="logo_footer text-center">
    <a href="#" onclick="showModal(); return false;">
      <img width="70" src="{{ asset('images/airtelmoney.png') }}" alt="Bank E"
        style="transition: transform 0.3s ease-in-out; border-radius: 50%;"
        onmouseover="this.style.transform = 'scale(1.1)';"
        onmouseout="this.style.transform = 'scale(1)';" />
      <div class="mt-1">Airtel Money</div>
    </a>
  </div>


  <div class="logo_footer text-center">
    <a href="#" onclick="showModal(); return false;">
      <img width="70" src="{{ asset('images/mpamba.png') }}" alt="Bank F"
        style="transition: transform 0.3s ease-in-out; border-radius: 50%;"
        onmouseover="this.style.transform = 'scale(1.1)';"
        onmouseout="this.style.transform = 'scale(1)';" />
      <div class="mt-1">TNM Mpamba</div>
    </a>
  </div>

 
  <!-- <div class="logo_footer text-center">
    <a href="#" onclick="showModal(); return false;">
      <img width="70" src="{{ asset('images/standard.png') }}" alt="Bank G"
        style="transition: transform 0.3s ease-in-out; border-radius: 50%;"
        onmouseover="this.style.transform = 'scale(1.1)';"
        onmouseout="this.style.transform = 'scale(1)';" />
      <div class="mt-1">Bank G</div>
    </a>
  </div> -->


</div>

    </div>

    <p>Your order is MWK<span id="order-amount">{{ $order->total }}</span></p>
    <div id="wrapper"></div>
    <button type="button" id="start-payment-button" class="btn btn-primary" onClick="makePayment()">Pay Now</button>
  </div>
</div>

{{-- MODAL --}}
<div id="modal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%;
     background-color: rgba(0, 0, 0, 0.5); z-index: 9999;">
  <div style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%);
       background-color: white; padding: 20px; border-radius: 10px; max-width: 500px;">
    <h4 class="text-center mb-3">PAYMENT FORM</h4>
    <p class="login-box-msg font-weight-bolder">
      Add 2 extra zeros to the amount you are paying. (E.g., MWK100 → MWK10000)<br>
      The last 2 digits are used as decimals.
    </p>
    
    <form method="POST" action="{{ front_route('orders.pay', $order->number) }}">
    @csrf
  <div class="mb-2">
    <label for="name">Name:</label>
    <input type="text" id="name" name="name" class="form-control" required>
  </div>

  <div class="mb-2">
    <label for="amount">Amount (MWK):</label>
    <input type="number" id="amount" name="amount" class="form-control" required>
  </div>

  <input type="hidden" name="order_number" value="{{ $order->number }}">

  <div class="mt-3 text-center">
    <button type="submit" class="btn btn-success">Proceed</button>
    <button type="button" class="btn btn-secondary" onclick="hideModal();">Cancel</button>
  </div>
</form>

  </div>
</div>

{{-- JS --}}
<script>

</script>

<script>
  function showModal() {
  // Get the amount from the page
  const orderAmount = document.getElementById('order-amount').innerText;

  // Set it into the input field in the modal (multiply by 100 to match instruction)
  document.getElementById('amount').value = parseFloat(orderAmount) * 100;

  // Show the modal
  document.getElementById('modal').style.display = 'block';
}

function hideModal() {
  document.getElementById('modal').style.display = 'none';
}

  function hideModal() {
    document.getElementById('modal').style.display = 'none';
  }

  function makePayment() {
    const orderNumber = "{{ $order->number }}";
    const amount = "{{ $order->total }}";
    const currency = "MWK";
    const customerEmail = "{{ $order->customer_email ?? 'yourmail@mail.com' }}";
    const firstName = "{{ $order->customer_first_name ?? 'Customer' }}";
    const lastName = "{{ $order->customer_last_name ?? 'Name' }}";
    const txRef = 'TX-' + Math.floor((Math.random() * 1000000000) + 1);
    const callbackUrl = "{{ url(front_route('checkout.success')) }}?order_number=" + orderNumber + "&tx_ref=" + txRef;

    PaychanguCheckout({
      public_key: "PUB-laOeSTzLfFJtg0gsF6ZIu8r0TVFuZc4t",
      tx_ref: txRef,
      amount: parseFloat(amount),
      currency: currency,
      callback_url: callbackUrl,
      return_url: "",
      customer: {
        email: customerEmail,
        first_name: firstName,
        last_name: lastName,
      },
      customization: {
        title: "Order Payment",
        description: `Payment for order ${orderNumber}`,
      },
      meta: {
        uuid: "uuid",
        response: "Response"
      }
    });
  }
</script>
